%KM-BL function code

function dydt=KM_BL_F(t,y)

global mfp_OH L_far L_close a0_OH a0_O3 Dg_OH Gas_delta_far Gas_delta_close A
global V_close V_far W kgr Yield Dg_O3 OH_uptake O3_uptake mfp_O3
global a0_terpene terpene_uptake Dg_terpene mfp_terpene

dydt=zeros(3*L_far+3*L_close+6,1);  Pb=zeros(3*L_far+3*L_close+6,1);

%%%%%%%------------Transport fluxes------%%%%%%%%%%%%

JcollOH=W(1)./4.*y(L_close+L_far+1); %OH collision flux (cm-2 s-1)
JadsOH=a0_OH.*JcollOH; %OH adsorption flux (cm-2 s-1)
JdesOH=(a0_OH-OH_uptake)*JcollOH; %OH desorption flux (cm-2 s-1)

JcollO3=W(2)./4.*y(2*L_close+2*L_far+3); %O3 collision flux (cm-2 s-1)
JadsO3=a0_O3.*JcollO3; %O3 adsorption flux (cm-2 s-1)
JdesO3=(a0_O3-O3_uptake).*JcollO3; %O3 desorption flux (cm-2 s-1)

Jcollterpene=W(3)./4.*y(3*L_close+3*L_far+5); 
Jadsterpene=a0_terpene.*Jcollterpene; %Limonene collision flux (cm-2 s-1)
Jdesterpene=(a0_terpene-terpene_uptake).*Jcollterpene; %Limonene desorption flux (cm-2 s-1)

%%%%%%%------------Production and loss rates (cm-3 s-1)------%%%%%%%%%%%%

for i=1:L_far+L_close+1
    %OH
    Pb(i)=kgr(1)*y(i+L_far+L_close+2)*y(i+2*L_far+2*L_close+4)*Yield...
        -kgr(2)*y(i)*y(i+2*L_far+2*L_close+4)-kgr(3)*y(i);
    %O3
    Pb(i+L_far+L_close+2)=-kgr(1)*y(i+L_far+L_close+2)*y(i+2*L_far+2*L_close+4);

    %Limonene
    Pb(i+2*L_far+2*L_close+4)=-kgr(1)*y(i+L_far+L_close+2)*y(i+2*L_far+2*L_close+4)...
        -kgr(2)*y(i)*y(i+2*L_far+2*L_close+4);  
end


%%%%%%%------------Differential equations, change in conc. over time (cm-3 s-1, unless stated)------%%%%%%%%%%%%
%----OH---

%Layer furthest from the surface
for i=1
    dydt(i)= 0;
end

%Middle layers in the far boundary layer
for i=2:L_far-1
    dydt(i)= ((y(i-1)-y(i)).*Dg_OH(i-1)/Gas_delta_far).*A/V_far + ...
        ((y(i+1)-y(i)).*Dg_OH(i)/Gas_delta_far).*A/V_far + Pb(i);
end

%Last layer in the far boundary layer
dydt(L_far)=((y(L_far-1)-y(L_far)).*Dg_OH(L_far-1)/Gas_delta_far).*A/V_far + ...
        ((y(L_far+1)-y(L_far)).*Dg_OH(L_far)/((Gas_delta_far+Gas_delta_close)/2)).*A/V_far + Pb(L_far);

%First layer in the close boundary layer (next to the far boundary layer)
dydt(L_far+1)=((y(L_far)-y(L_far+1)).*Dg_OH(L_far)/((Gas_delta_far+Gas_delta_close)/2)).*A/V_close + ...
        ((y(L_far+2)-y(L_far+1)).*Dg_OH(L_far+1)/Gas_delta_close).*A/V_close + Pb(L_far+1);

%Middle layers in the close boundary layer
for i=L_far+2:L_far+L_close-1
    dydt(i)= ((y(i-1)-y(i)).*Dg_OH(i-1)/Gas_delta_close).*A/V_close + ...
        ((y(i+1)-y(i)).*Dg_OH(i)/Gas_delta_close).*A/V_close + Pb(i);
end

%Last layer in the close boundary layer (next to the mfp)
dydt(L_far+L_close)=((y(L_far+L_close-1)-y(L_far+L_close)).*Dg_OH(L_far+L_close-1)/Gas_delta_close).*A/V_close + ...
        ((y(L_far+L_close+1)-y(L_far+L_close)).*Dg_OH(L_far+L_close)/((Gas_delta_close)/2)).*A/V_close + Pb(L_far+L_close);

%Mean free path
dydt(L_far+L_close+1)= ((y(L_far+L_close)-y(L_far+L_close+1)).*Dg_OH(L_far+L_close)/(Gas_delta_close/2))./mfp_OH +...
    (JdesOH-JadsOH)./mfp_OH + Pb(L_far+L_close+1);

%Adsorbed on the surface (cm-2 s-1)
dydt(L_far+L_close+2)=(JadsOH-JdesOH);

%----O3----
%Layer furthest from the surface
for i=L_far+L_close+3
    dydt(i)=0;
end

%Middle layers in the far boundary layer
for i=L_far+L_close+4:2*L_far+L_close+1
    dydt(i)= ((y(i-1)-y(i)).*Dg_O3(i-1-L_far-L_close-2)/Gas_delta_far).*A/V_far + ...
        ((y(i+1)-y(i)).*Dg_O3(i-L_far-L_close-2)/Gas_delta_far).*A/V_far + Pb(i);
end

%Last layer in the far boundary layer
dydt(2*L_far+L_close+2)=((y(2*L_far+L_close+2-1)-y(2*L_far+L_close+2)).*Dg_O3(L_far-1)/Gas_delta_far).*A/V_far + ...
        ((y(2*L_far+L_close+2+1)-y(2*L_far+L_close+2)).*Dg_O3(L_far)/((Gas_delta_far+Gas_delta_close)/2)).*A/V_far + Pb(2*L_far+L_close+2);

%First layer in the close boundary layer (next to the far boundary layer)
dydt(2*L_far+L_close+3)=((y(2*L_far+L_close+3-1)-y(2*L_far+L_close+3)).*Dg_O3(L_far)/((Gas_delta_far+Gas_delta_close)/2)).*A/V_close + ...
        ((y(2*L_far+L_close+3+1)-y(2*L_far+L_close+3)).*Dg_O3(L_far+1)/Gas_delta_close).*A/V_close + Pb(2*L_far+L_close+3);

%Middle layers in the close boundary layer
for i=2*L_far+L_close+4:2*L_far+2*L_close+1
    dydt(i)= ((y(i-1)-y(i)).*Dg_O3(i-1-L_far-L_close-2)/Gas_delta_close).*A/V_close + ...
        ((y(i+1)-y(i)).*Dg_O3(i-L_far-L_close-2)/Gas_delta_close).*A/V_close + Pb(i);
end

%Last layer in the close boundary layer (next to the mfp)
dydt(2*L_far+2*L_close+2)=((y(2*L_far+2*L_close+2-1)-y(2*L_far+2*L_close+2)).*Dg_O3(L_far+L_close-1)/Gas_delta_close).*A/V_close + ...
        ((y(2*L_far+2*L_close+2+1)-y(2*L_far+2*L_close+2)).*Dg_O3(L_far+L_close)/((Gas_delta_close)/2)).*A/V_close + Pb(2*L_far+2*L_close+2);

%Mean free path
dydt(2*L_far+2*L_close+3)= ((y(2*L_far+2*L_close+3-1)-y(2*L_far+2*L_close+3)).*Dg_O3(L_far+L_close)/(Gas_delta_close/2))./mfp_O3 +...
    (JdesO3-JadsO3)./mfp_O3 + Pb(2*L_far+2*L_close+3);

%Adsorbed on the surface (cm-2 s-1)
dydt(2*L_far+2*L_close+4)=(JadsO3-JdesO3);

%----terpene----
%Layer furthest from the surface
for i=2*L_far+2*L_close+5
    dydt(i)=0;
end

%Middle layers in the far boundary layer
for i=2*L_far+2*L_close+6:3*L_far+2*L_close+3
    dydt(i)= ((y(i-1)-y(i)).*Dg_terpene(i-1-2*L_close-2*L_far-4)/Gas_delta_far).*A/V_far + ...
        ((y(i+1)-y(i)).*Dg_terpene(i-2*L_close-2*L_far-4)/Gas_delta_far).*A/V_far + Pb(i);
end

%Last layer in the far boundary layer
dydt(3*L_far+2*L_close+4)=((y(3*L_far+2*L_close+4-1)-y(3*L_far+2*L_close+4)).*Dg_terpene(L_far-1)/Gas_delta_far).*A/V_far + ...
        ((y(3*L_far+2*L_close+4+1)-y(3*L_far+2*L_close+4)).*Dg_terpene(L_far)/((Gas_delta_far+Gas_delta_close)/2)).*A/V_far + Pb(3*L_far+2*L_close+4);

%First layer in the close boundary layer (next to the far boundary layer)
dydt(3*L_far+2*L_close+5)=((y(3*L_far+2*L_close+5-1)-y(3*L_far+2*L_close+5)).*Dg_terpene(L_far)/((Gas_delta_far+Gas_delta_close)/2)).*A/V_close + ...
        ((y(3*L_far+2*L_close+5+1)-y(3*L_far+2*L_close+5)).*Dg_terpene(L_far+1)/Gas_delta_close).*A/V_close + Pb(3*L_far+2*L_close+5);

%Middle layers in the close boundary layer
for i=3*L_far+2*L_close+6:3*L_far+3*L_close+3
    dydt(i)= ((y(i-1)-y(i)).*Dg_terpene(i-1-2*L_close-2*L_far-4)/Gas_delta_close).*A/V_close + ...
        ((y(i+1)-y(i)).*Dg_terpene(i-2*L_close-2*L_far-4)/Gas_delta_close).*A/V_close + Pb(i);
end

%Last layer in the close boundary layer (next to the mfp)
dydt(3*L_far+3*L_close+4)=((y(3*L_far+3*L_close+4-1)-y(3*L_far+3*L_close+4)).*Dg_terpene(L_far+L_close-1)/Gas_delta_close).*A/V_close + ...
        ((y(3*L_far+3*L_close+4+1)-y(3*L_far+3*L_close+4)).*Dg_terpene(L_far+L_close)/((Gas_delta_close)/2)).*A/V_close + Pb(3*L_far+3*L_close+4);

%Mean free path
dydt(3*L_far+3*L_close+5)= ((y(3*L_far+3*L_close+5-1)-y(3*L_far+3*L_close+5)).*Dg_terpene(L_far+L_close)/(Gas_delta_close/2))./mfp_terpene +...
    (Jdesterpene-Jadsterpene)./mfp_terpene + Pb(3*L_far+3*L_close+5);

%Adsorbed on the surface (cm-2 s-1)
dydt(3*L_far+3*L_close+6)=(Jadsterpene-Jdesterpene);

end